/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.d.b;
import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eapsetting.SchedulerConfig;
import com.tp_link.eap.domain.globalsetting.Profile;
import com.tp_link.eap.domain.globalsetting.ProfileTime;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.globalsetting.model.ProfileInfo;
import com.tp_link.eap.monitor.globalsetting.model.ProfileTimeInfo;
import com.tp_link.eap.monitor.globalsetting.model.SchedulerAssociationApInfo;
import com.tp_link.eap.monitor.globalsetting.repo.GlobalEnableRepository;
import com.tp_link.eap.monitor.globalsetting.repo.MongoSequenceRepository;
import com.tp_link.eap.monitor.globalsetting.repo.ProfileRepository;
import com.tp_link.eap.monitor.globalsetting.repo.ProfileTimeRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SsidRepository;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.globalsetting.service.j;
import com.tp_link.eap.monitor.globalsetting.service.k;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.repo.site.SiteRepository;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.p.a;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="profileService")
public class ProfileService
extends com.tp_link.eap.i.a.a<Profile>
implements j {
    @Autowired
    private ProfileRepository a;
    @Autowired
    private ProfileTimeRepository b;
    @Autowired
    private MongoSequenceRepository c;
    @Autowired
    private g d;
    @Autowired
    private SsidRepository e;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a f;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b g;
    @Autowired
    private ApRepository h;
    @Autowired
    private GlobalEnableRepository i;
    @Autowired
    private MongoTemplate j;
    @Autowired
    private k k;
    @Autowired
    private Validator validator;
    @Autowired
    private SiteRepository l;
    private final Logger m = LoggerFactory.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addProfile(String name, boolean sendMessage) {
        Integer n2;
        Object object;
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.m.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object2 = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object2) {
            if (this.l.findBySiteName(string) == null) {
                this.m.warn("Site {} doesn't exist.", (Object)string);
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            object = this.a.findByNameAndSite(name, string);
            if (this.a.countBySite(com.tp_link.eap.d.b.a()) >= (long)com.tp_link.eap.util.e.bw.intValue()) {
                return new OperationResponse(ResErrorCode.aQ);
            }
            if (object != null) {
                return new OperationResponse(ResErrorCode.aR, String.format("Profile %s is already existed", name), null);
            }
            object = new Profile();
            object.setName(name);
            object.setSite(string);
            n2 = this.c.getSequenceStartNumber("profile");
            object.setId(n2);
            com.tp_link.eap.d.b.g((String)string);
            this.a.save(object);
        }
        object2 = this.a.findByNameAndSite(name, string);
        if (object2 == null) {
            return new OperationResponse(ResErrorCode.i);
        }
        if (sendMessage) {
            object = this.d.a((Integer)1, n2, null, null);
            this.f.refreshRecord("schedulerList", object);
        }
        object = new HashMap();
        object.put("profileId", object2.getId());
        return new OperationResponse(ResErrorCode.a, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delProfile(Integer id) {
        if (id == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.m.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        com.tp_link.eap.d.b.g((String)string);
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            ProfileTime profileTime2;
            if (this.l.findBySiteName(string) == null) {
                this.m.warn("Site {} doesn't exist.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            Profile profile = (Profile)this.a.findOne(id);
            if (profile == null) {
                return new OperationResponse(ResErrorCode.aT);
            }
            List list = profile.getTimeList();
            if (list != null) {
                for (ProfileTime profileTime2 : list) {
                    this.b.delete(profileTime2);
                }
            }
            SchedulerConfig schedulerConfig = this.d.a((Integer)2, id, null, profile);
            this.a.delete(id);
            profileTime2 = new Query();
            profileTime2.addCriteria(Criteria.where((String)"site").is((Object)string)).addCriteria(Criteria.where((String)"schedulerId").is((Object)id));
            Update update = new Update();
            update.set("schedulerId", null).set("schedulerAction", (Object)false);
            this.j.updateMulti((Query)profileTime2, update, Ssid.class);
            this.f.refreshRecord("schedulerList", schedulerConfig);
        }
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delProfileTime(Integer profileId, Integer timeId) {
        SchedulerConfig schedulerConfig;
        if (profileId == null || timeId == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.m.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        com.tp_link.eap.d.b.g((String)string);
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.l.findBySiteName(string) == null) {
                this.m.warn("Site {} doesn't exist.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            Profile profile = (Profile)this.a.findOne(profileId);
            ProfileTime profileTime = (ProfileTime)this.b.findOne(timeId);
            if (profile == null || profileTime == null) {
                return new OperationResponse(ResErrorCode.aY);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(timeId);
            schedulerConfig = this.d.a((Integer)2, profileId, arrayList, null);
            List list = profile.getTimeList();
            boolean bl = list.remove(profileTime);
            if (!bl) {
                return new OperationResponse(ResErrorCode.i);
            }
            this.b.delete(timeId);
            profile.setTimeList(list);
            this.a.save(profile);
        }
        this.f.refreshRecord("schedulerList", schedulerConfig);
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OperationResponse editProfileTime(Integer id, ProfileTime profileTime, boolean sendMessage) {
        if (id == null || profileTime == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.m.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        com.tp_link.eap.d.b.g((String)string);
        Integer n2 = 3;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ProfileTime profileTime2 = null;
        SchedulerConfig schedulerConfig = null;
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.l.findBySiteName(string) == null) {
                this.m.warn("Site {} doesn't exist.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            Profile profile = (Profile)this.a.findOne(id);
            if (profile == null) {
                return new OperationResponse(ResErrorCode.aV);
            }
            ArrayList<ProfileTime> arrayList2 = ((Profile)this.a.findOne(id)).getTimeList();
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<ProfileTime>();
            }
            if (profileTime.getId() == null) {
                if (this.b.countByProfileId(id) >= (long)com.tp_link.eap.util.e.bz.intValue()) {
                    return new OperationResponse(ResErrorCode.aW);
                }
                List list = profile.getTimeList();
                if (list != null) {
                    for (ProfileTime profileTime3 : list) {
                        Integer n3 = profileTime3.getId();
                        profileTime3.setId(null);
                        if (profileTime3.equals((Object)profileTime)) {
                            return new OperationResponse(ResErrorCode.aX);
                        }
                        profileTime3.setId(n3);
                    }
                }
                Integer n4 = this.c.getSequenceStartNumber("profileTime");
                profileTime.setId(n4);
                profileTime.setSite(string);
                profileTime.setProfileId(profile.getId());
                this.b.save(profileTime);
                arrayList2.add(profileTime);
                profile.setTimeList(arrayList2);
                this.a.save(profile);
                n2 = 1;
                arrayList.add(n4);
            } else {
                List list = ((Profile)this.a.findOne(id)).getTimeList();
                for (ProfileTime profileTime4 : list) {
                    if (profileTime4.toString().equals(profileTime.toString())) {
                        this.m.debug("profiletime no change");
                        break;
                    }
                    Integer n5 = profileTime4.getId();
                    profileTime4.setId(profileTime.getId());
                    if (profileTime4.toString().equals(profileTime.toString())) {
                        return new OperationResponse(ResErrorCode.aX);
                    }
                    profileTime4.setId(n5);
                }
                profileTime2 = (ProfileTime)this.b.findOne(profileTime.getId());
                profileTime2.setNameForOld(profile.getName());
                this.b.save(profileTime);
                arrayList.add(profileTime.getId());
            }
        }
        if (sendMessage) {
            schedulerConfig = this.d.a(n2, id, arrayList, profileTime2);
            this.f.refreshRecord("schedulerList", schedulerConfig);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public List<Profile> getAll() {
        Iterator<Profile> iterator = this.a.findAll().iterator();
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public Profile getById(Integer id) {
        return (Profile)this.a.findOne(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse editProfileName(Integer id, String name) {
        Profile profile;
        Profile profile2;
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.m.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.l.findBySiteName(string) == null) {
                this.m.warn("Site {} doesn't exist.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            profile2 = (Profile)this.a.findOne(id);
            if (profile2 == null) {
                return new OperationResponse(ResErrorCode.d);
            }
            com.tp_link.eap.d.b.g((String)string);
            Profile profile3 = this.a.findByNameAndSite(name, string);
            if (profile3 != null && !id.equals(profile3.getId())) {
                return new OperationResponse(ResErrorCode.aS, String.format("Profile with name %s is already existed,can not rename.", name), null);
            }
            profile = new Profile();
            profile.setName(profile2.getName());
            profile.setId(profile2.getId());
            profile2.setName(name);
            this.a.save(profile2);
        }
        object = 3;
        profile2 = this.d.a((Integer)object, id, null, profile);
        this.f.refreshRecord("schedulerList", profile2);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public ProfileTime getTimeById(Integer timeId) {
        return (ProfileTime)this.b.findOne(timeId);
    }

    @Override
    public boolean deleteAll() {
        this.a.deleteAll();
        this.b.deleteAll();
        return true;
    }

    @Override
    public OperationResponse saveProfile(Profile profile, boolean sendMessage) {
        Object v;
        if (profile == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        OperationResponse operationResponse = this.addProfile(profile.getName(), sendMessage);
        Object object = operationResponse.getResult();
        if (object != null && object instanceof Map && (v = ((Map)object).get("profileId")) != null && v instanceof Integer) {
            int n2 = (Integer)v;
            List list = profile.getTimeList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (ProfileTime profileTime : list) {
                    profileTime.setId(null);
                    this.editProfileTime(n2, profileTime, sendMessage);
                }
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public void deleteBySite() {
        String string = com.tp_link.eap.d.b.a();
        List<Profile> list = this.a.findBySiteOrderByIdAsc(string);
        if (!CollectionUtils.isEmpty(list)) {
            for (Profile profile : list) {
                List list2 = profile.getTimeList();
                if (list2 != null) {
                    this.b.delete(list2);
                }
                this.a.delete(profile);
            }
        }
    }

    public List<Profile> getList(QueryPage queryPage) {
        List<Profile> list = this.a.getByFilters(queryPage, null, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Profile> getList(QueryPage queryPage, QuerySort querySort) {
        List<Profile> list = this.a.getByFilters(queryPage, querySort, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Profile> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Profile> list = this.a.getByFilters(queryPage, null, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Profile> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Profile> list = this.a.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(null, null, filters, searchFilters).size();
    }

    @Override
    public List<Profile> getAllWithLazyLoad() {
        Query query = new Query();
        query.fields().include("id").include("name");
        query.with(new Sort(Sort.DEFAULT_DIRECTION, new String[]{"id"}));
        query.addCriteria(Criteria.where((String)"site").is((Object)com.tp_link.eap.d.b.a()));
        List list = this.j.find(query, Profile.class);
        return list;
    }

    @Override
    public List<Profile> getAllBySite(String site) {
        return this.a.findBySiteOrderByIdAsc(site);
    }

    @Override
    public OperationResponse getGridSchedulerProfiles(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = null;
        if (queryData == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("id");
        }
        grid = new Grid(queryData);
        grid.initFilters(queryData.getFilters());
        long l2 = this.count(grid.getFilters(), grid.getSearchFilters());
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        if (list == null || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        ArrayList<ProfileInfo> arrayList = new ArrayList<ProfileInfo>();
        for (Profile profile : list) {
            ProfileInfo profileInfo = new ProfileInfo();
            profileInfo.setId(profile.getId());
            profileInfo.setName(profile.getName());
            arrayList.add(profileInfo);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse addSchedulerProfile(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        ProfileInfo profileInfo = (ProfileInfo)JSONObject.toBean((JSONObject)jSONObject, ProfileInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)profileInfo);
        if (!operationResponse.success()) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.addProfile(profileInfo.getName(), true);
    }

    @Override
    public OperationResponse modifySchedulerProfile(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        ProfileInfo profileInfo = (ProfileInfo)JSONObject.toBean((JSONObject)jSONObject, ProfileInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)profileInfo);
        if (!operationResponse.success()) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.editProfileName(profileInfo.getId(), profileInfo.getName());
    }

    @Override
    public OperationResponse deleteSchedulerProfile(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("profileId");
        return this.delProfile(n2);
    }

    @Override
    public OperationResponse getGridProfileTime(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        Integer n2 = null;
        try {
            n2 = Integer.parseInt(queryData.getFilters().get("profileId").toString());
        }
        catch (Exception exception) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        queryData.getFilters().put("profileId", n2);
        grid.initFilters(queryData.getFilters());
        Long l2 = this.k.count(grid);
        if (n2 == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        Profile profile = this.getById(n2);
        if (profile == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        grid.setTotalRows(l2.longValue());
        List list = this.k.getList(grid);
        if (list == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        grid.setTotalRows(l2.longValue());
        ArrayList<ProfileTimeInfo> arrayList = new ArrayList<ProfileTimeInfo>();
        int n3 = queryData.getCurrentPage();
        int n4 = queryData.getCurrentPageSize();
        int n5 = (n3 - 1) * n4;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ProfileTime profileTime = (ProfileTime)list.get(i2);
            ProfileTimeInfo profileTimeInfo = new ProfileTimeInfo();
            profileTimeInfo.setIndex(i2 + 1 + n5);
            profileTimeInfo.setId(profileTime.getId());
            profileTimeInfo.setProfileId(n2);
            profileTimeInfo.setProfileName(profile.getName());
            String string = "";
            string = string + (profileTime.getEndTimeH() < 10 ? "0" + profileTime.getEndTimeH() : profileTime.getEndTimeH());
            string = string + ":";
            string = string + (profileTime.getEndTimeM() < 10 ? "0" + profileTime.getEndTimeM() : profileTime.getEndTimeM());
            profileTimeInfo.setEndTime(string);
            String string2 = "";
            string2 = string2 + (profileTime.getStartTimeH() < 10 ? "0" + profileTime.getStartTimeH() : profileTime.getStartTimeH());
            string2 = string2 + ":";
            string2 = string2 + (profileTime.getStartTimeM() < 10 ? "0" + profileTime.getStartTimeM() : profileTime.getStartTimeM());
            profileTimeInfo.setStartTime(string2);
            if (profileTime.getDayType().equals("Everyday")) {
                profileTimeInfo.setDayType("Daily");
            } else if (profileTime.getDayType().equals("Select Days")) {
                profileTimeInfo.setDayType("Custom");
            } else {
                profileTimeInfo.setDayType(profileTime.getDayType());
            }
            arrayList.add(profileTimeInfo);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getProfileTime(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("profileId");
        Integer n3 = jSONObject.getInt("timeId");
        Profile profile = this.getById(n2);
        if (profile == null) {
            return com.tp_link.eap.util.e.bd;
        }
        List list = profile.getTimeList();
        if (list == null) {
            return com.tp_link.eap.util.e.bd;
        }
        for (ProfileTime profileTime : list) {
            if (!profileTime.getId().equals(n3)) continue;
            ProfileTimeInfo profileTimeInfo = new ProfileTimeInfo();
            profileTimeInfo.setAllDay(profileTime.getAllDay());
            profileTimeInfo.setDayFri(profileTime.getDayFri());
            profileTimeInfo.setDayMon(profileTime.getDayMon());
            profileTimeInfo.setDaySat(profileTime.getDaySat());
            profileTimeInfo.setDaySun(profileTime.getDaySun());
            profileTimeInfo.setDayThu(profileTime.getDayThu());
            profileTimeInfo.setDayTue(profileTime.getDayTue());
            profileTimeInfo.setDayWed(profileTime.getDayWed());
            profileTimeInfo.setDayType(profileTime.getDayType());
            profileTimeInfo.setEndTimeH(profileTime.getEndTimeH());
            profileTimeInfo.setEndTimeM(profileTime.getEndTimeM());
            profileTimeInfo.setStartTimeH(profileTime.getStartTimeH());
            profileTimeInfo.setStartTimeM(profileTime.getStartTimeM());
            return new OperationResponse(ResErrorCode.a, (Object)profileTimeInfo);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse addProfileTime(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        ProfileTimeInfo profileTimeInfo = (ProfileTimeInfo)JSONObject.toBean((JSONObject)jSONObject, ProfileTimeInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)profileTimeInfo);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        if (profileTimeInfo == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Integer n2 = profileTimeInfo.getProfileId();
        if (n2 == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        ProfileTime profileTime = new ProfileTime();
        this.a(profileTimeInfo, profileTime);
        return this.editProfileTime(n2, profileTime, true);
    }

    @Override
    public OperationResponse modifyProfileTime(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        ProfileTimeInfo profileTimeInfo = (ProfileTimeInfo)JSONObject.toBean((JSONObject)jSONObject, ProfileTimeInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)profileTimeInfo);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        if (profileTimeInfo == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Integer n2 = profileTimeInfo.getProfileId();
        if (n2 == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        ProfileTime profileTime = this.getTimeById(profileTimeInfo.getId());
        if (profileTime == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        this.a(profileTimeInfo, profileTime);
        return this.editProfileTime(n2, profileTime, true);
    }

    @Override
    public OperationResponse deleteProfileTime(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("profileId");
        Integer n3 = jSONObject.getInt("timeId");
        return this.delProfileTime(n2, n3);
    }

    @Override
    public OperationResponse getSchedulerProfileList(ControlType controlType, JSONObject reqObj) {
        ArrayList<ProfileInfo> arrayList = new ArrayList<ProfileInfo>();
        List<Profile> list = this.getAllWithLazyLoad();
        HashMap<String, ArrayList<ProfileInfo>> hashMap = new HashMap<String, ArrayList<ProfileInfo>>();
        if (list != null) {
            for (Profile profile : list) {
                ProfileInfo profileInfo = new ProfileInfo();
                profileInfo.setId(profile.getId());
                profileInfo.setName(profile.getName());
                arrayList.add(profileInfo);
            }
        }
        hashMap.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getGridSchedulerApInfo(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.m.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        if (queryData == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        if (queryData.getSortName() == null || queryData.getSortName().equals("")) {
            queryData.setSortName("id");
        }
        grid.initFilters(queryData.getFilters());
        grid.initFilters("site", (Object)com.tp_link.eap.d.b.a(), QueryFilter.FilterType.eq);
        grid.initFilters("status", (Object)2, QueryFilter.FilterType.lt);
        grid.initSearch(queryData.getSearchKey(), new String[]{"name", "mac"});
        long l2 = this.g.count(grid.getFilters(), grid.getSearchFilters());
        grid.setTotalRows(l2);
        List list = this.g.getList(grid);
        if (list == null || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        ArrayList<SchedulerAssociationApInfo> arrayList = new ArrayList<SchedulerAssociationApInfo>();
        int n2 = queryData.getCurrentPage();
        int n3 = queryData.getCurrentPageSize();
        int n4 = (n2 - 1) * n3;
        int n5 = 1;
        for (Ap ap : list) {
            SchedulerAssociationApInfo schedulerAssociationApInfo = new SchedulerAssociationApInfo();
            schedulerAssociationApInfo.setId(ap.getId());
            schedulerAssociationApInfo.setIndex(n4 + n5++);
            schedulerAssociationApInfo.setMac(ap.getMac());
            schedulerAssociationApInfo.setName(ap.getName());
            schedulerAssociationApInfo.setProfileId(ap.getSchedulerId());
            schedulerAssociationApInfo.setSchedulerAction(ap.getSchedulerAction());
            arrayList.add(schedulerAssociationApInfo);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    private OperationResponse a(ProfileTimeInfo profileTimeInfo, ProfileTime profileTime) {
        if (profileTimeInfo == null || profileTime == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        profileTime.setDayType(profileTimeInfo.getDayType());
        switch (profileTimeInfo.getDayType()) {
            case "Weekend": {
                profileTime.setDaySat(Boolean.valueOf(true));
                profileTime.setDaySun(Boolean.valueOf(true));
                profileTime.setDayFri(Boolean.valueOf(false));
                profileTime.setDayMon(Boolean.valueOf(false));
                profileTime.setDayThu(Boolean.valueOf(false));
                profileTime.setDayTue(Boolean.valueOf(false));
                profileTime.setDayWed(Boolean.valueOf(false));
                break;
            }
            case "Weekday": {
                profileTime.setDaySat(Boolean.valueOf(false));
                profileTime.setDaySun(Boolean.valueOf(false));
                profileTime.setDayFri(Boolean.valueOf(true));
                profileTime.setDayMon(Boolean.valueOf(true));
                profileTime.setDayThu(Boolean.valueOf(true));
                profileTime.setDayTue(Boolean.valueOf(true));
                profileTime.setDayWed(Boolean.valueOf(true));
                break;
            }
            case "Everyday": {
                profileTime.setDayFri(Boolean.valueOf(true));
                profileTime.setDayMon(Boolean.valueOf(true));
                profileTime.setDaySat(Boolean.valueOf(true));
                profileTime.setDaySun(Boolean.valueOf(true));
                profileTime.setDayThu(Boolean.valueOf(true));
                profileTime.setDayTue(Boolean.valueOf(true));
                profileTime.setDayWed(Boolean.valueOf(true));
                break;
            }
            default: {
                profileTime.setDayFri(Boolean.valueOf(profileTimeInfo.getDayFri() == null ? false : profileTimeInfo.getDayFri()));
                profileTime.setDayMon(Boolean.valueOf(profileTimeInfo.getDayMon() == null ? false : profileTimeInfo.getDayMon()));
                profileTime.setDaySat(Boolean.valueOf(profileTimeInfo.getDaySat() == null ? false : profileTimeInfo.getDaySat()));
                profileTime.setDaySun(Boolean.valueOf(profileTimeInfo.getDaySun() == null ? false : profileTimeInfo.getDaySun()));
                profileTime.setDayThu(Boolean.valueOf(profileTimeInfo.getDayThu() == null ? false : profileTimeInfo.getDayThu()));
                profileTime.setDayTue(Boolean.valueOf(profileTimeInfo.getDayTue() == null ? false : profileTimeInfo.getDayTue()));
                profileTime.setDayWed(Boolean.valueOf(profileTimeInfo.getDayWed() == null ? false : profileTimeInfo.getDayWed()));
            }
        }
        profileTime.setAllDay(profileTimeInfo.getAllDay());
        if (profileTimeInfo.getAllDay().booleanValue()) {
            profileTime.setStartTimeH(Integer.valueOf(0));
            profileTime.setStartTimeM(Integer.valueOf(0));
            profileTime.setEndTimeH(Integer.valueOf(23));
            profileTime.setEndTimeM(Integer.valueOf(59));
        } else {
            int n2 = profileTimeInfo.getEndTimeH();
            int n3 = profileTimeInfo.getEndTimeM();
            int n4 = profileTimeInfo.getStartTimeH();
            int n5 = profileTimeInfo.getStartTimeM();
            if (n2 < n4 || n2 == n4 && n3 <= n5) {
                return new OperationResponse(ResErrorCode.aU);
            }
            profileTime.setStartTimeH(profileTimeInfo.getStartTimeH());
            profileTime.setStartTimeM(profileTimeInfo.getStartTimeM());
            profileTime.setEndTimeH(profileTimeInfo.getEndTimeH());
            profileTime.setEndTimeM(profileTimeInfo.getEndTimeM());
        }
        return com.tp_link.eap.util.e.bd;
    }
}

